'OPTION SYSTEM SPI GP18,GP19,GP16
'OPTION LCDPANEL ILI9488, LANDSCAPE,GP14,GP13,GP12
'OPTION TOUCH GP15,GP17
'GUI CALIBRATE 0, 3977, 3836, -1279, -887
'OPTION WIFI "TEST","88888888"

OPTION AUTORUN ON
OPTION EXPLICIT
OPTION BASE 0

DIM BUFF(2048) AS INTEGER	
DIM BUFF2(2048) AS INTEGER
DIM MMIP AS STRING
DIM CAMIP AS STRING
DIM IPOCTETS(4) AS INTEGER
DIM SCANIP AS STRING
DIM K AS STRING
DIM HOST AS STRING
DIM OKRESULT AS STRING
DIM GETREQ AS STRING
DIM JPGHEADER AS STRING
DIM HTTPHEADEREND AS STRING
DIM CAPFILE AS STRING

DO WHILE MM.INFO(IP ADDRESS) = "0.0.0.0"
	IF TIMER > 5000 THEN
		PRINT "ENSURE YOU HAVE A WIFI NETWORK CONFIGURED"
		PRINT "OPTION WIFI ";CHR$(34);"SSID";CHR$(34);",";CHR$(34);"PASSWORD"
		PRINT "RESTARTING"
		PAUSE 100
		CPU RESTART
	ENDIF
LOOP

MMIP=MM.INFO(IP ADDRESS)
CAMIP="0.0.0.0"
OKRESULT="200 OK"
GETREQ = "GET /capture HTTP/1.1"+CHR$(13)+CHR$(10)+CHR$(13)+CHR$(10)
JPGHEADER = CHR$(255)+CHR$(216)+CHR$(255)+CHR$(224)+CHR$(0)+CHR$(16)+"JFIF"
HTTPHEADEREND = CHR$(13)+CHR$(10)+CHR$(13)+CHR$(10)
CAPFILE="A:\CAPTURE.JPG"
GETOCTETS
DOHELP

'MAIN LOOP
DO
	K=INKEY$
	IF K="?" THEN DOHELP
	IF K="~" THEN CPU RESTART
	IF K="V" OR K="v" THEN CHECKIP
	IF K="G" OR K="g" THEN GETIMAGE
	IF K="D" OR K="d" THEN SHOWIMAGE
	IF (TOUCH(X)>-1) AND (TOUCH(Y)>-1) THEN
		GETIMAGE
		SHOWIMAGE
		PAUSE 500
	ENDIF
LOOP

SUB CHECKIP
	LOCAL INTEGER I
	LOCAL STRING K
	LOCAL INTEGER C
	I=0
	K=""
	PRINT "ENTER LAST OCTET OF IP:";
	DO WHILE K<> CHR$(13)
		K=INKEY$
		PRINT K;
		C=ASC(K)-48
		IF C>=0 AND C<=9 THEN I=I*10+C
	LOOP
	PRINT	'next line
	HOST=""
	IPOCTETS(3)=I
	SCANIP=GETIPSTRING()
	PRINT SCANIP
	SCANSINGLE
	DOHELP
END SUB

SUB GETOCTETS
	LOCAL INTEGER P,I,C 
	P=0
	IPOCTETS(0)=0
	IPOCTETS(1)=0
	IPOCTETS(2)=0
	IPOCTETS(3)=0
	FOR I = 1 TO LEN(MMIP)
		C=ASC(MID$(MMIP,I,1))
		IF C=ASC(".") THEN P=P+1
		C=C-48
		IF C>=0 AND C<=9 THEN
			IF P < 4 THEN
				IPOCTETS(P)=IPOCTETS(P)*10+C
			ENDIF
		ENDIF
	NEXT I
END SUB

SUB SCANSINGLE
	LOCAL INTEGER J
	SCANIP=GETIPSTRING()
	'PRINT SCANIP
	ON ERROR IGNORE
	WEB OPEN TCP CLIENT SCANIP,80
	IF	MM.ERRNO<>0 THEN					'retry on fail
		WEB CLOSE TCP CLIENT
		PAUSE 100
		WEB OPEN TCP CLIENT SCANIP,80
	ENDIF
	IF MM.ERRNO=0 THEN
		PRINT SCANIP;" RESPONDING."
		CAMIP=SCANIP
		PRINT "CAMERA SET TO ";CAMIP
	ELSE
		PRINT SCANIP;" SCANNED"
		PRINT "NO HTTP SERVER"
		PRINT MM.ERRMSG$;MM.ERRNO
	ENDIF
	WEB CLOSE TCP CLIENT
	PAUSE 1000
	ON ERROR CLEAR
	ON ERROR ABORT
END SUB

FUNCTION GETIPSTRING() AS STRING
	GETIPSTRING=STR$(IPOCTETS(0))+"."+STR$(IPOCTETS(1))+"."+STR$(IPOCTETS(2))+"."+STR$(IPOCTETS(3))
END FUNCTION

SUB DOHELP
	PRINT
	PRINT "~ TO REBOOT"
	PRINT "? FOR THIS HELP"
	PRINT "V TO CHECK A SINGLE IP"
	PRINT "G TO GET IMAGE AND SAVE TO ";CAPFILE
	PRINT "D TO DISPLAY ";CAPFILE
	PRINT
END SUB

SUB GETIMAGE ''from CAMIP/capture and save to A:\capture.jpg
	LOCAL INTEGER J
	LOCAL INTEGER L
	PRINT "SENDING CAPTURE REQUEST TO ";CAMIP
	PRINT GETREQ
	WEB OPEN TCP CLIENT CAMIP,80
	WEB TCP CLIENT REQUEST GETREQ, BUFF()
	PAUSE 500
	WEB CLOSE TCP CLIENT
	J=LINSTR(BUFF(),OKRESULT)
	IF J>0 THEN 
		PRINT "REQUEST SUCCESS"
		J=LINSTR(BUFF(),HTTPHEADEREND)
		IF J>0 THEN
			PRINT "HTTP HEADER OK"
			PRINT LGETSTR$(BUFF(),1,J)
		ELSE
			PRINT "HEADER END NOT FOUND"
		ENDIF
		J=LINSTR(BUFF(),JPGHEADER)
		IF J>0 THEN
			L=(LLEN(BUFF())+1-J)
			PRINT "JPEG HEADER FOUND AT ";J			
			PRINT L;" BYTES OF JPEG DATA."
			OPEN CAPFILE FOR OUTPUT AS #1
			LONGSTRING RIGHT BUFF2(),BUFF(),L	''copy JPG data only
			LONGSTRING PRINT #1,BUFF2()			''write to file,''trailing CR/LF doesn't seem to affect decoder
			CLOSE #1
			PRINT "SAVED TO A:\CAPTURE.JPG"
		ELSE
			PRINT "NO JPEG HEADER FOUND"
		ENDIF
	ELSE
		PRINT "REQUEST FAILED"
	ENDIF

	'LONGSTRING PRINT BUFF()
	LONGSTRING CLEAR BUFF() 
	PRINT "CAPTURE REQUEST FINISHED"
END SUB

SUB SHOWIMAGE
	PRINT "LOADING A:\CAPTURE.JPG"
	LOAD JPG CAPFILE, 0,0
	PRINT "IMAGE LOADED"
END SUB
